/*
 * Decompiled with CFR 0.152.
 */
package view;

import app.PlotDataXY;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import util.Logger;
import view.MainView;
import view.PlotXY;

public class PlotWindow
extends JFrame
implements WindowListener {
    static Logger logger = Logger.getLogger();
    private static final long serialVersionUID = 1L;
    private MainView myMW;
    private PlotXY myPlotXY;
    private List<PlotDataXY> myDataList;
    private String Caption;
    private String XLabel;
    private String YLabel;
    public double floorX;
    public double ceilX;
    public double floorY;
    public double ceilY;
    private double tickSzX;
    private double tickSzY;
    private double factorX;
    private double factorY;
    public List<Double> XNumberList;
    public List<Double> YNumberList;

    public void setCaption(String s) {
        this.Caption = s;
    }

    public String getCaption() {
        return this.Caption;
    }

    public void setXLabel(String s) {
        this.XLabel = s;
    }

    public void setYLabel(String s) {
        this.YLabel = s;
    }

    public String getXLabel() {
        return this.XLabel;
    }

    public String getYLabel() {
        return this.YLabel;
    }

    public PlotWindow(MainView mw) {
        logger.entry(4, "PlotWindow.PlotWindow");
        this.myMW = mw;
        this.setLocation(this.myMW.getPlotwinLocX(), this.myMW.getPlotwinLocY());
        this.setDefaultCloseOperation(2);
        this.setTitle("Plot");
        this.setSize(this.myMW.getPlotwinSzX(), this.myMW.getPlotwinSzY());
        this.Caption = "";
        this.XLabel = "";
        this.YLabel = "";
        this.floorX = 0.0;
        this.ceilX = 0.0;
        this.floorY = 0.0;
        this.ceilY = 0.0;
        this.tickSzX = 0.0;
        this.tickSzY = 0.0;
        this.factorX = 1.0;
        this.factorY = 1.0;
        this.XNumberList = new ArrayList<Double>();
        this.YNumberList = new ArrayList<Double>();
        this.myDataList = new ArrayList<PlotDataXY>();
        this.addWindowListener(this);
        logger.exit(4, "PlotWindow.PlotWindow");
    }

    @Override
    public void windowIconified(WindowEvent e) {
        logger.log(5, "PlotWindow WindowListener: windowIconified.");
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
        logger.log(5, "PlotWindow WindowListener: windowDeiconified.");
    }

    @Override
    public void windowOpened(WindowEvent e) {
        logger.log(5, "PlotWindow WindowListener: windowOpened.");
    }

    @Override
    public void windowClosing(WindowEvent e) {
        logger.entry(4, "PlotWindow.WindowClosing");
        this.myMW.removePlotWindow(this);
        logger.exit(4, "PlotWindow .WindowClosing");
    }

    @Override
    public void windowClosed(WindowEvent e) {
        logger.log(5, "PlotWindow WindowListener: windowClosed.");
    }

    @Override
    public void windowActivated(WindowEvent e) {
        logger.log(5, "PlotWindow WindowListener: windowActivated.");
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
        logger.log(5, "PlotWindow WindowListener: windowDeactivated.");
    }

    public void addPlotDataXY(PlotDataXY pd) {
        logger.entry(4, "PlotWindow.addPlotDataXY");
        logger.log(5, "Datalen = " + pd.DataMap.keySet().size());
        this.myDataList.add(pd);
        logger.exit(4, "PlotWindow.addPlotDataXY");
    }

    public void displayPlot() {
        logger.entry(4, "PlotWindow.displayPlot");
        this.calcBoundaries();
        this.myPlotXY = new PlotXY(this, this.myDataList);
        this.add(this.myPlotXY);
        logger.exit(4, "PlotWindow.displayPlot");
    }

    private int roundTickSize(double sz) {
        logger.entry(6, "PlotDataXY.roundTickSize: " + sz);
        int result = 1;
        result = sz < 1.5 ? 1 : (sz < 3.0 ? 2 : (sz < 7.0 ? 5 : 10));
        logger.exit(6, "PlotDataXY.roundTickSize");
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private double normalizeTickSize(double sz) {
        block2: {
            PlotWindow.logger.entry(6, "PlotWindow.normalizeTickSize: " + sz);
            factor = 1.0;
            h = sz;
            if (!(sz > 1.0)) ** GOTO lbl12
            while (h > 10.0) {
                h /= 10.0;
                factor *= 10.0;
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                h *= 10.0;
                factor /= 10.0;
lbl12:
                // 2 sources

                ** while (h < 1.0)
            }
        }
        PlotWindow.logger.exit(6, "PlotWindow.normalizeTickSize");
        return factor;
    }

    private void calcNumbering() {
        logger.entry(6, "PlotDataXY.calcNumbering");
        this.XNumberList.clear();
        double num = this.floorX;
        while (num <= this.ceilX) {
            this.XNumberList.add(num);
            num += this.tickSzX;
        }
        this.YNumberList.clear();
        int itickSz = 1;
        int itick = 1;
        int iceil = 1;
        int ifactor = 1;
        ifactor = this.factorY < 1.0 ? (int)(1.0 / this.factorY) : (int)this.factorY;
        itickSz = (int)(this.tickSzY * (double)ifactor);
        itick = (int)(this.floorY * (double)ifactor);
        iceil = (int)(this.ceilY * (double)ifactor);
        while (itick <= iceil) {
            this.YNumberList.add((double)itick / (double)ifactor);
            itick += itickSz;
        }
        logger.exit(6, "PlotDataXY.calcNumbering");
    }

    public void calcBoundaries() {
        logger.entry(6, "PlotWindow.calcBoundaries");
        double minX = 0.0;
        double maxX = 0.0;
        double minY = 0.0;
        double maxY = 0.0;
        int count = 0;
        for (PlotDataXY pd : this.myDataList) {
            if (++count == 1) {
                minX = pd.getMinX();
                maxX = pd.getMaxX();
                minY = pd.getMinY();
                maxY = pd.getMaxY();
                continue;
            }
            if (pd.getMinX() < minX) {
                minX = pd.getMinX();
            }
            if (pd.getMaxX() > maxX) {
                maxX = pd.getMaxX();
            }
            if (pd.getMinY() < minY) {
                minY = pd.getMinY();
            }
            if (!(pd.getMaxY() < maxY)) continue;
            maxY = pd.getMaxY();
        }
        logger.log(6, "minX = " + minX);
        logger.log(6, "maxX = " + maxX);
        logger.log(6, "minY = " + minY);
        logger.log(6, "maxY = " + maxY);
        double range = maxX - minX;
        double delta = range / 5.0;
        this.factorX = this.normalizeTickSize(delta);
        this.tickSzX = (double)this.roundTickSize(delta /= this.factorX) * this.factorX;
        this.floorX = Math.floor(minX / this.tickSzX) * this.tickSzX;
        this.ceilX = Math.ceil(maxX / this.tickSzX) * this.tickSzX;
        range = maxY - minY;
        delta = range / 5.0;
        this.factorY = this.normalizeTickSize(delta);
        this.tickSzY = (double)this.roundTickSize(delta /= this.factorY) * this.factorY;
        this.floorY = Math.floor(minY / this.tickSzY) * this.tickSzY;
        this.ceilY = Math.ceil(maxY / this.tickSzY) * this.tickSzY;
        logger.log(6, "floorX = " + this.floorX);
        logger.log(6, "ceilX = " + this.ceilX);
        logger.log(6, "floorY = " + this.floorY);
        logger.log(6, "ceilY = " + this.ceilY);
        this.calcNumbering();
        logger.exit(6, "PlotWindow.calcBoundaries");
    }

    public void updateSize() {
        logger.entry(6, "PlotDataXY.updateSize");
        this.myMW.setPlotwinSzX(this.getWidth());
        this.myMW.setPlotwinSzY(this.getHeight());
        this.myMW.setPlotwinLocX(this.getLocation().x);
        this.myMW.setPlotwinLocY(this.getLocation().y);
        logger.exit(6, "PlotDataXY.updateSize");
    }
}

